package net.roseindia.application;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import net.roseindia.domain.Student;
import net.roseindia.service.ApplicationService;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;

class StudentForm extends JFrame implements ActionListener {
	JButton SUBMIT;
	JPanel panel;
	DefaultFormBuilder builder;
	JLabel rollLabel, nameLabel, courseLabel, addressLabel;
	final JTextField rollText, nameText, courseText, addressText;

	StudentForm() {
		rollLabel = new JLabel();
		rollLabel.setText("Roll No:");
		rollText = new JTextField(25);

		nameLabel = new JLabel();
		nameLabel.setText("Name:");
		nameText = new JTextField(25);

		courseLabel = new JLabel();
		courseLabel.setText("Course:");
		courseText = new JTextField(25);

		addressLabel = new JLabel();
		addressLabel.setText("Address:");
		addressText = new JTextField(25);

		SUBMIT = new JButton("SUBMIT");

		builder = new DefaultFormBuilder(new FormLayout(""));
		builder.setBorder(BorderFactory.createEmptyBorder(20, 4, 20, 4));
		builder.appendColumn("center:pref");
		builder.appendColumn("5dlu");
		builder.appendColumn("fill:max(pref; 100px)");

		builder.append("Roll No:", rollText);
		builder.nextLine();
		builder.append("Name:", nameText);
		builder.nextLine();
		builder.append("Course:", courseText);
		builder.nextLine();
		builder.append("Address:", addressText);
		builder.nextLine();
		builder.append(SUBMIT);

		add(builder.getPanel());
		SUBMIT.addActionListener(this);
		setTitle("STUDENT REGISTRATION FORM");
	}

	public void actionPerformed(ActionEvent ae) {
		int rollNo = 0;
		String name = nameText.getText();
		String course = courseText.getText();
		String address = addressText.getText();

		String rollString = rollText.getText();

		if (rollString.length() > 0) {
			rollNo = Integer.parseInt(rollString);
		}
		setVisible(false);

		if (rollNo != 0 || name.length() > 0 || course.length() > 0
				|| address.length() > 0) {

			Student student = new Student();
			student.setRollNo(rollNo);
			student.setName(name);
			student.setCourse(course);
			student.setAddress(address);
			ApplicationService service = new ApplicationService();
			service.addStudent(student);
		} else {
			JOptionPane.showMessageDialog(this,
					"Please Specify All Fields Correctly");
		}
	}
}