package dom;

import java.io.File;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomXmlParsingExample {
	public static void main(String argv[]) {

		try {
			File xmlFile = new File("G:\\xmlfiles\\student.xml");
			DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder documentBuilder = documentBuilderFactory
					.newDocumentBuilder();
			Document document = documentBuilder.parse(xmlFile);
			document.getDocumentElement().normalize();
			NodeList nodeList = document.getElementsByTagName("STUDENT");
			
			for (int i = 0; i < nodeList.getLength(); i++) {
				Node node = nodeList.item(i);
				if (node.getNodeType() == Node.ELEMENT_NODE) {
					Element element = (Element) node;
					
					NodeList rollNodeList = element.getElementsByTagName("ROLL");
					Element roll = (Element) rollNodeList.item(0);
					NodeList rollNode = roll.getChildNodes();
					System.out.println("Roll : " + ((Node) rollNode.item(0)).getNodeValue());
					
					NodeList nameNodeList = element.getElementsByTagName("NAME");
					Element name = (Element) nameNodeList.item(0);
					NodeList nameNode = name.getChildNodes();
					System.out.println("NAME : " + ((Node) nameNode.item(0)).getNodeValue());
					
					NodeList ageNodeList = element.getElementsByTagName("AGE");
					Element age = (Element) ageNodeList.item(0);
					NodeList ageNode = age.getChildNodes();
					System.out.println("AGE : " + ((Node) ageNode.item(0)).getNodeValue());
					
					NodeList courseNodeList = element.getElementsByTagName("COURSE");
					Element course = (Element) courseNodeList.item(0);
					NodeList courseNode = course.getChildNodes();
					System.out.println("COURSE : " + ((Node) courseNode.item(0)).getNodeValue());
					
					NodeList addressNodeList = element.getElementsByTagName("ADDRESS");
					Element address = (Element) addressNodeList.item(0);
					NodeList addressNode = address.getChildNodes();
					System.out.println("ADDRESS : "+((Node) addressNode.item(0)).getNodeValue());
				}

			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}